<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('detalle_pagos', function (Blueprint $table) {
            $table->bigIncrements('idDetallePago');
            $table->unsignedBigInteger('idVenta');
            $table->unsignedBigInteger('idTipoPago');
            $table->decimal('monto', 10, 2);
            $table->dateTime('fechaPago');
            $table->timestamps();

            $table->foreign('idVenta')->references('idVenta')->on('ventas')->onDelete('cascade');
            $table->foreign('idTipoPago')->references('idTipoPago')->on('tipo_pagos');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('detalle_pagos');
    }
};
