<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('validacions', function (Blueprint $table) {
            $table->bigIncrements('idValidacion');
            $table->unsignedBigInteger('idBoleto');
            $table->unsignedBigInteger('idBoletero');
            $table->unsignedBigInteger('idPuerta');
            $table->dateTime('fechaHoraValidacion');
            $table->timestamps();

            $table->foreign('idBoleto')->references('idBoleto')->on('boletos');
            $table->foreign('idBoletero')->references('idUsuario')->on('usuarios');
            $table->foreign('idPuerta')->references('idPuerta')->on('puertas');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('validacions');
    }
};
