<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('boletos', function (Blueprint $table) {
            $table->bigIncrements('idBoleto');
            $table->unsignedBigInteger('idPersona');
            $table->unsignedBigInteger('idVenta');
            $table->unsignedBigInteger('idEvento');
            $table->string('codigoQR');
            $table->dateTime('fechaVenta');
            $table->enum('estado', ['valido', 'usado']);
            $table->timestamps();

            $table->foreign('idPersona')->references('idPersona')->on('personas');
            $table->foreign('idVenta')->references('idVenta')->on('ventas')->onDelete('cascade');
            $table->foreign('idEvento')->references('idEvento')->on('eventos');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('boletos');
    }
};
