<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('usuarios', function (Blueprint $table) {
            $table->bigIncrements('idUsuario');
            $table->string('correo')->unique();
            $table->string('contrasena');
            $table->string('estado');
            $table->unsignedBigInteger('idRol');
            $table->unsignedBigInteger('idPersona')->nullable();
            $table->timestamps();

            $table->foreign('idRol')->references('idRol')->on('rols');
            $table->foreign('idPersona')->references('idPersona')->on('personas');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('usuarios');
    }
};
