<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Venta extends Model
{
    use HasFactory;

    protected $table = 'ventas';
    protected $primaryKey = 'idVenta';

    protected $fillable = [
        'fechaVenta',
        'totalVenta',
    ];

    public function boletos()
    {
        return $this->hasMany(Boleto::class, 'idVenta');
    }
}
