<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Persona extends Model
{
    use HasFactory;

    protected $table = 'personas';
    protected $primaryKey = 'idPersona';
    public $timestamps = true;

    protected $fillable = [
        'nombre',
        'apellido',
        'correo',
        'telefono',
        'fechaRegistro',
    ];

    public function boletos()
    {
        return $this->hasMany(Boleto::class, 'idPersona');
    }
}
