<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Evento extends Model
{
    use HasFactory;

    protected $table = 'eventos';
    protected $primaryKey = 'idEvento';

    protected $fillable = [
        'nombre',
        'fecha',
        'hora',
        'ubicacion',
        'descripcion',
    ];

    public function boletos()
    {
        return $this->hasMany(Boleto::class, 'idEvento');
    }
}
