<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Boleto extends Model
{
    use HasFactory;

    protected $table = 'boletos';
    protected $primaryKey = 'idBoleto';

    protected $fillable = [
        'idPersona',
        'idVenta',
        'idEvento',
        'codigoQR',
        'fechaVenta',
        'estado',
    ];

    public function persona()
    {
        return $this->belongsTo(Persona::class, 'idPersona');
    }

    public function venta()
    {
        return $this->belongsTo(Venta::class, 'idVenta');
    }

    public function evento()
    {
        return $this->belongsTo(Evento::class, 'idEvento');
    }
}
