<?php

namespace App\Http\Controllers;

use App\Models\Puerta;
use Illuminate\Http\Request;

class PuertaController extends Controller
{
    /**
     * Muestra todas las puertas.
     */
    public function index()
    {
        return response()->json(Puerta::all());
    }

    /**
     * Almacena una nueva puerta.
     */
    public function store(Request $request)
    {
        $puerta = Puerta::create($request->only(['nombrePuerta', 'descripcion']));
        return response()->json($puerta, 201);
    }

    /**
     * Muestra una puerta específica.
     */
    public function show($id)
    {
        $puerta = Puerta::find($id);
        if (!$puerta) {
            return response()->json(['message' => 'Puerta no encontrada'], 404);
        }
        return response()->json($puerta);
    }

    /**
     * Actualiza una puerta específica.
     */
    public function update(Request $request, $id)
    {
        $puerta = Puerta::find($id);
        if (!$puerta) {
            return response()->json(['message' => 'Puerta no encontrada'], 404);
        }
        $puerta->update($request->only(['nombrePuerta', 'descripcion']));
        return response()->json($puerta);
    }

    /**
     * Elimina una puerta específica.
     */
    public function destroy($id)
    {
        $puerta = Puerta::find($id);
        if (!$puerta) {
            return response()->json(['message' => 'Puerta no encontrada'], 404);
        }
        $puerta->delete();
        return response()->json(['message' => 'Puerta eliminada']);
    }
}
