<?php

namespace App\Http\Controllers;

use App\Models\DetallePago;
use Illuminate\Http\Request;

class DetallePagoController extends Controller
{
    /**
     * Muestra todos los registros de detalle_pagos.
     */
    public function index()
    {
        return response()->json(DetallePago::all());
    }

    /**
     * Almacena un nuevo detalle de pago.
     */
    public function store(Request $request)
    {
        $detallePago = DetallePago::create($request->all());
        return response()->json($detallePago, 201);
    }

    /**
     * Muestra un detalle de pago específico.
     */
    public function show($id)
    {
        $detallePago = DetallePago::find($id);
        if (!$detallePago) {
            return response()->json(['message' => 'DetallePago no encontrado'], 404);
        }
        return response()->json($detallePago);
    }

    /**
     * Actualiza un detalle de pago específico.
     */
    public function update(Request $request, $id)
    {
        $detallePago = DetallePago::find($id);
        if (!$detallePago) {
            return response()->json(['message' => 'DetallePago no encontrado'], 404);
        }
        $detallePago->update($request->all());
        return response()->json($detallePago);
    }

    /**
     * Elimina un detalle de pago específico.
     */
    public function destroy($id)
    {
        $detallePago = DetallePago::find($id);
        if (!$detallePago) {
            return response()->json(['message' => 'DetallePago no encontrado'], 404);
        }
        $detallePago->delete();
        return response()->json(['message' => 'DetallePago eliminado']);
    }
}
