<?php

namespace App\Http\Controllers;

use App\Models\Boleto;
use Illuminate\Http\Request;

class BoletoController extends Controller
{
    public function index()
    {
        return Boleto::all();
    }

    public function store(Request $request)
    {
        $boleto = Boleto::create($request->all());
        return response()->json($boleto, 201);
    }

    public function show($id)
    {
        return Boleto::findOrFail($id);
    }

    public function update(Request $request, $id)
    {
        $boleto = Boleto::findOrFail($id);
        $boleto->update($request->all());
        return response()->json($boleto, 200);
    }

    public function destroy($id)
    {
        Boleto::destroy($id);
        return response()->json(null, 204);
    }
}
